//***************************************************************************

// Copyright (C) 2009 Realmac Software Ltd
//
// These coded instructions, statements, and computer programs contain
// unpublished proprietary information of Realmac Software Ltd
// and are protected by copyright law. They may not be disclosed
// to third parties or copied or duplicated in any form, in whole or
// in part, without the prior written consent of Realmac Software Ltd.

// Created by Danny Greg on 22/10/2010. 

//***************************************************************************

#import <Cocoa/Cocoa.h>

//***************************************************************************

/*!
	\brief
	Posted both when no updates are found, and if updates are found.
	
	If updates are found, the receiver should redirect the User-Agent to the URL in the <tt>RMPluginStoreDidFetchUpdatesURLKey</tt> <tt>userInfo</tt> key.
 */
extern NSString *const RMPluginStoreDidFetchUpdatesNotificationName;
	extern NSString *const RMPluginStoreDidFetchUpdatesURLKey; //NSURL - The URL to the updates page the app should show to the user. 

extern NSString *const RMPluginStoreDidFailToFetchUpdatesNotificationName;
	extern NSString *const RMPluginStoreDidFailToFetchUpdatesErrorKey; //NSError

//***************************************************************************

@interface RMPluginStore : NSObject 
{
	NSString *_appID;
	NSURLConnection *_updatesConnection;
	BOOL _checkInBackground;
}

@property (nonatomic, assign) BOOL checkForUpdatesInBackground;

- (id)initWithAppID:(NSString *)appID;

/*!
	\brief
	This must be called in an environment with a serviced run loop.
	
	\param versionMap
	An <tt>NSDictionary</tt> object mapping bundle identifier <tt>NSString</tt> objects to the value for the bundle's <tt>CFBundleVersion</tt>.
	
	\details
	Posts the notifications documented above on completion.
 */
- (void)fetchUpdatesForBundleIDsAndVersions:(NSDictionary *)versionMap;

/*!
	\brief
	The plugin store URL is different for each application.
 */
- (NSURL *)pluginStoreURL;

@end
